// 单独把打印对uc 写在这是因为 eslint 检查到new ActiveXObject 要报错。解决办法：把assets设置为忽略文件
const utilPrintUC = {
  data() {
    return {
      cabUrl: require('@assets/axtive/BartenderActivex.cab'),
      entity_active_xObject: null
    }
  },
  methods: {
    initAx(init_value = this.entity_active_xObject) {
      let r = null
      try {
        r = init_value || new ActiveXObject('BarTenderActiveX.BarTenderHelper')
      } catch (error) {
        alert(error)
      }
      this.entity_active_xObject = r
      return r
    },
    barTenderPrint(data, XObject, callback) {
      var path = 'D://BarTender//label.btw' // 配置打印标签的全路径地址'/'用'//'表示
      if (!data) {
        throw new Error('参数无效，请检查')
      }
      try {
        var _activeXobj = XObject
        var _activeXstr = JSON.stringify(data)
        console.log('打印数据:', _activeXstr)
        const success_ids = []
        if (_activeXobj.Print(path, _activeXstr)) {
          this.$message('成功')
          // 计数打印成功的BarCode
          success_ids.push(data.BarCode)
        } else {
          this.$message('打印失败')
        }
        if (callback && success_ids.length) {
          callback(success_ids)
        }
      } catch (error) {
        alert(error)
      }
    },
    get_data_print(bodyParms, callback = this.success_print_callback) {
      this.$API
        .post(`${this.module_name}/print/`, {}, {}, bodyParms)
        .then(res => {
          if (res.status === 200) {
            for (const item of res.data) {
              this.barTenderPrint(item, this.entity_active_xObject, callback)
            }
          }
        })
    },
    success_print_callback(ids) {
      const parm = {
        serial_code_list: ids
      }
      this.$API.post(`${this.module_name}/callback/`, {}, {}, parm).then(() => {
        console.log('回写成功')
      })
    }
  }
}
export default utilPrintUC
