const BASE = {
  data() {
    return {
      module_name: '',
      api_bill_base_save: '', // 保存的aip
      api_bill_base_query: '' // 查询的api
    }
  },
  methods: {
    /**
     * 单行删除
     * @param {*} id
     * @param {*} url
     */
    base_delete_one(id, moduleName = this.module_name) {
      return this.$API.delete(moduleName + '/delete_one/' + id + '/')
    },
    /**
     * 多行删除
     * @param {*} parm
     * @param {*} url
     */
    base_delete_list(parm = {}, moduleName = this.module_name) {
      return this.$API.delete(moduleName, {}, {}, { data: parm })
    },
    /**
     * 保存
     * @param {*} routerParm
     * @param {*} argsParm
     * @param {*} bodyParm
     * @param {*} url
     */
    base_bill_save(
      routerParm = {},
      argsParm = {},
      bodyParm = {},
      api = this.api_bill_base_save,
      moduleName = this.module_name
    ) {
      const urls = moduleName + '/' + api + '/'
      return this.$API.post(urls, routerParm, argsParm, bodyParm)
    },
    /**
     * 查询
     * @param {*} routerParm
     * @param {*} argsParm
     * @param {*} moduleName
     * @param {*} api
     */
    base_bill_query(
      routerParm = {},
      argsParm = {},
      api = this.api_bill_base_query,
      moduleName = this.module_name
    ) {
      const urls = moduleName + '/' + api + '/'
      return this.$API.get(urls, routerParm, argsParm)
    },
    before_delete_hint(bill_ids = [], bill_type = this.bill_type, callback) {
      const parm = {
        bill_type,
        bill_ids,
        operator_id: 0
      }
      this.$API.post('mesAPI/before_delete_hint/', {}, {}, parm).then(res => {
        const { iHintType, sHint } = res.data
        if (iHintType === 0) {
          callback ? callback(bill_ids) : ''
          // 校验通过
        } else if (iHintType === 1) {
          this.$message.error(sHint)
        } else if (iHintType === 2) {
          this.$confirm(`${sHint}`, '提示', {
            confirmButtonText: '确定',
            cancelButtonText: '取消',
            type: 'warning'
          }).then(() => {
            callback ? callback(bill_ids) : ''
          })
        } else if (iHintType === 3) {
          this.$message.warning(sHint)
        }
      })
    }
  }
}
export default BASE
