// 单表uc
const utilUc = {
  data() {
    return {
      page_out_dialog: 1,
      per_page_out_dialog: 10,
      total_out_dialog: 0,
      module_name_out_dialog: '', // 最外层弹出框主表名
      api_out_dialog_query_list: 'query_list',
      data_list_out_dialog: [], // 最外层弹出框的列表
      search_parms_out_dialog: {}, // 最外层弹出框搜索条件
      rowId_out_dialog: '', // 最外层弹出框选中行的ID
      visible_out_dialog: false, // 控制外层弹出框是否显示
      row_out_dialog: {}, // 最外层弹出框 选中的当前行
      module_name_inner_list_dialog: '', // 最内层弹出框路由
      api_in_dialog_query_list: 'query_list',
      rowId_inner_dialog: '', // 最内层弹出框选中行的ID（一般来说是多选）
      data_list_inner_dialog: [], // 最内层弹出框数据列表
      module_name_inner_dialog: '', // 最内层弹出框保存时的路由
      visible_inner_dialog: false, // 控制内层弹出框是否显示
      visible_inner_dialog_loading: false, // 最内层弹出框加载数据：loading
      flage_prop: 'id'
    }
  },
  computed: {
    routerParmOut: function() {
      // 外层弹框的请求路由参数
      return {}
    },
    routerParmInner: function() {
      // 内层弹框的请求路由参数
      return {}
    },
    bodyParmInner: function() {
      // 内层弹框的body路由参数
      return {}
    },
    routerParmInnerSave: function() {
      // 内层弹框的保存时的body参数
      return {}
    }
  },
  methods: {
    /**
     * 最外层弹出框列表
     * @param {*} id
     */
    query_data_list_out_dialog() {
      // 问号参数
      const parm2 = {
        page: this.page_out_dialog,
        per_page: this.per_page_out_dialog
      }
      const p = Object.assign(parm2, this.search_parms_out_dialog) // 做为问号参数
      this.rowId_out_dialog = ''
      if (this.is_restful) {
        this.api_out_dialog_query_list = ''
      }
      this.$API
        .get(
          `${this.module_name}/${this.module_name_out_dialog}/${
            this.api_out_dialog_query_list
          }/`,
          this.routerParmOut,
          p
        )
        .then(res => {
          res.data.table.map(item => {
            item.isCheck = false
          })
          this.data_list_out_dialog = res.data.table
          this.total_out_dialog = res.data.paging.total
          this.page_out_dialog = res.data.paging.page
          this.per_page_out_dialog = res.data.paging.per_page
        })
        .finally(() => {})
    },
    // 最外层弹出框分页size cb
    handle_size_change_dialog(pageSize) {
      this.per_page_out_dialog = pageSize
      this.query_data_list_out_dialog()
    },
    // 最外层弹出框当前页 change cb
    handle_current_change_dialog(currentPage) {
      this.page_out_dialog = currentPage
      this.query_data_list_out_dialog()
    },
    /**
     * 删除单条订单
     * @param {} id 选中行的ID
     */
    delete_singe_out_dialog(id = this.rowId) {
      if (!id) {
        this.$message('您没有选中任何数据项,请选中后再操作')
        return
      }
      const target = this.query_data_list_out_dialog.find(item => {
        return item.id === this.rowId_out_dialog
      })
      if (target.bill_status !== '0') {
        this.$message('非草稿状态不能进行删除操作')
        return
      }
      const routerParm = {
        routerUrl: 'id',
        data: {
          id: id
        }
      }
      this.$confirm('确定删除该单吗?', '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(() => {
        this.$API
          .delete(`/${this.module_name_dialog}/delete_one/`, routerParm)
          .then(res => {
            this.data_list_out_dialog.find((item, index) => {
              if (item && item.id === id) {
                this.data_list_out_dialog.splice(index, 1)
                return
              }
            })
            this.rowId_out_dialog = ''
          })
      })
    },
    /**
     * 选择表格当前行
     * @param {*} currentRow
     */
    tab_handle_current_change_dialog(currentRow) {
      if (currentRow) {
        this.rowId_out_dialog = currentRow.id
        for (const item of this.data_list_out_dialog) {
          if (currentRow.id !== item.id) {
            item.isCheck = false
          }
        }
        currentRow.isCheck = !currentRow.isCheck
      }
    },
    double_click_row_dialog(currentRow) {
      // 双击外层弹框表格数据
      if (currentRow) {
        this.rowId_out_dialog = currentRow.id || currentRow[this.flage_prop]
        this.visible_inner_dialog = true
        this.query_data_list_inner_dialog()
      }
    },
    /**
     * 清空搜索框表单
     * @param {*} formName 表单的ID
     */
    reset_form_dialog() {
      this.search_parms_out_dialog = {}
    },
    /**
     * 重置数据
     */
    reset_data_dialog() {
      this.page_out_dialog = 1
      this.per_page_out_dialog = 10
      this.total_out_dialog = 0
      this.data_list_out_dialog = []
      this.search_parms_out_dialog = {}
      this.rowId_out_dialog = ''
    },
    /**
     * 刷新按钮
     */
    refresh_dialog() {
      // this.resetForm()
      // this.resetData()
      this.query_data_list_out_dialog()
    },
    query_data_list_inner_dialog() {
      // 内层弹出框的list
      this.data_list_inner_dialog = []
      this.visible_inner_dialog_loading = true
      if (this.is_restful) {
        this.api_in_dialog_query_list = ''
      }
      if (!this.routerParmInner) {
        return
      }
      if (!Object.keys(this.routerParmInner).length) {
        return
      }
      this.$API
        .post(
          `${this.module_name}/${this.module_name_inner_dialog}/${
            this.api_in_dialog_query_list
          }/`,
          this.routerParmInner,
          {},
          this.bodyParmInner
        )
        .then(res => {
          res.data.map(item => {
            if (item.is_choose === '0') {
              item.isCheck = false
            } else {
              item.isCheck = true
            }
          })
          this.data_list_inner_dialog = res.data
        })
        .finally(() => {
          this.visible_inner_dialog_loading = false
        })
    },
    // 选中最外层的某一行 （重写单选框的情况）
    select_check_box_out_dialog(id) {
      console.log(id)
    },
    // 选中最内曾的某一行  （重写单选框的情况）
    select_check_box_inner_dialog(id) {
      console.log(id)
    },
    // 外层弹出框的确定按钮 应该是选中一条
    save_select_one_out_dialog() {
      const row = this.data_list_out_dialog.find(item => {
        return item.isCheck
      })
      if (!row) {
        this.$message.error('请选择数据项')
        return
      }
      this.visible_inner_dialog = true
      this.rowId_out_dialog = row.id // 设置选中行的id
      this.row_out_dialog = row // 设置选中行row
      this.query_data_list_inner_dialog()
    },
    addImprot() {
      // 导入
      this.visible_out_dialog = true
      this.query_data_list_out_dialog()
    },
    // 单击改变 外层单元格的一行
    set_current_out_dialog(row) {
      this.data_list_out_dialog.find(item => {
        if (item.isCheck) {
          item.isCheck = false
        }
      })
      this.row_out_dialog = row
      this.$refs.multiple_table_Out.toggleRowSelection(row)
      row.isCheck = !row.isCheck
    },
    // 双击 外层单元格的一行
    double_click_row_out_dialog(row) {
      this.data_list_out_dialog.find(item => {
        if (item.isCheck && row.id !== item.id) {
          item.isCheck = false
        }
      })
      this.$refs.multiple_table_Out.setCurrentRow(row)
      this.row_out_dialog = row
      row.isCheck = true
      this.visible_inner_dialog = true
      this.query_data_list_inner_dialog()
    },
    // 单击改变 最内层单元格的一行 // 设置单行选中
    set_current_inner_dialog(row) {
      this.$refs.multiple_table_inner_dialog.toggleRowSelection(row)
    },
    // 保存最内层弹出框的数据
    save_list_inner_dialog() {
      console.log(this.routerParmInnerSave)
      if (!this.routerParmInnerSave) {
        return
      }
      if (!Object.keys(this.routerParmInnerSave).length) {
        return
      }
      this.$API
        .post(
          `${this.module_name}/${this.module_name_out_dialog}/`,
          {},
          {},
          this.routerParmInnerSave
        )
        .then(() => {
          this.visible_inner_dialog = false
          this.visible_out_dialog = false
          this.query_bill(this.bill_hdr.data.id)
        })
    },
    /**
     * 合计字段
     * @param {d\} param
     */
    getSummaries(param) {
      const { columns, data } = param
      const sums = []
      let _sums = 0
      for (const item of data) {
        for (const prop in item) {
          if (item[prop]) {
            _sums++
            break
          }
        }
      }
      columns.forEach((column, index) => {
        if (index === 0) {
          sums[index] = '合计'
          return
        }
        if (index === 1) {
          sums[index] = _sums
          return
        }
        const { property } = column
        this.summaryAttr.forEach(sum => {
          const { type, attr } = sum
          if (property === attr) {
            const values = data.map(item => {
              const val = Number(item[column.property])
              return isNaN(val) ? 0 : val
            })
            if (values.length) {
              const count = values.reduce((prev, curr) => {
                return prev + curr
              }, 0)
              switch (type) {
                case 'sum':
                  sums[index] = count
                  break
                case 'ava':
                  sums[index] = _sums === 0 ? '-' : (count / _sums).toFixed(2)
                  break
              }
            } else {
              sums[index] = '-'
            }
          }
        })
      })
      return sums
    },
    delete_check_code(ids) {
      if (!ids) {
        return
      }
      const id_ = typeof ids === 'string' ? [ids] : ids
      const parm = { id_list: id_, bill_id: this.bill_hdr.data.id }
      this.$API.delete(`${this.module_name}/item/`, {}, {}, parm).then(() => {
        this.query_bill()
      })
    }
  }
}
export default utilUc
