import Vue from 'vue'
import App from './App'
import router from './router'
// import { routerBeforeEach } from './router/before_each.js'
import ElementUI from 'element-ui'
import store from './store/storeAll'
import 'element-ui/lib/theme-chalk/index.css'
import '@assets/css/reset.css'
import '@assets/css/table.css'
import '@assets/css/new.css'
import '@assets/icon/iconfont.css'
import zhLocale from 'element-ui/lib/locale/lang/zh-CN'
import eleLocale from 'element-ui/lib/locale'
import pubFunction from './common/pub_function/function.js'
import axios from 'axios'
import API from '@utils/sha256/myHttpClient'
import fetch from './api/fetch'
import bill_type from '@basicClass/etc_type'
import appConfig from '@basicClass/app_config'
import utilsExcel from '@utils/excel/utils_excel'
import * as filters from './filters' // global filters
import '@components/baseComponents/index'
import NProgress from 'nprogress' // 引入nprogress插件
import 'nprogress/nprogress.css'  // 这个nprogress样式必须引入
axios.defaults.headers.common['Authorization'] = sessionStorage.getItem(
  'mes_token'
)
router.beforeEach((to, from, next) => {
  if (to.matched.some(record => record.meta.requireAuth)) { // 判断该路由是否需要登录权限
    if (sessionStorage.mes_token) { // 判断缓存里面是否有 userName  //在登录的时候设置它的值
      next()
    } else {
      if (to.fullPath === '/hsEdi/edi_index') {
        next()
      } else {
        next({
          path: '/login',
          query: {
            redirect: to.fullPath
          } // 将跳转的路由path作为参数，登录成功后跳转到该路由
        })
      }
    }
  } else {
    next()
  }
})

Vue.config.productionTip = false
Vue.prototype.$API = API
Vue.prototype.$pub_fun = pubFunction
Vue.prototype.$fecth = fetch
Vue.prototype.$bill_type = bill_type
Vue.prototype.$appConfig = appConfig
Vue.prototype.$Loading = ElementUI.Loading
Vue.prototype.$utilsExcel = utilsExcel
Vue.prototype.$NProgress = NProgress

Vue.use(ElementUI)
eleLocale.use(zhLocale)
const HEADER_KEY = 'Authentication-Token'
Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
})
new Vue({
  el: '#app',
  router,
  store,
  template: '<App/>',
  render: h => h(App),
  components: {
    App
  },
  beforeCreate() {
    const val = sessionStorage.getItem('token')
    if (val) {
      axios.defaults.headers.common[HEADER_KEY] = val
    }
  }
})
