import Vue from 'vue'
import Router from 'vue-router'
const Login = r =>
  require.ensure([], () => r(require('@/components/layout/login')), 'Login')
const Register = r =>
  require.ensure(
    [],
    () => r(require('@/components/layout/register')),
    'Register'
  )
const retrievePassword = r =>
  require.ensure(
    [],
    () => r(require('@/components/layout/retrieve_password')),
    'retrievePassword'
  )
const Main = r =>
  require.ensure([], () => r(require('@/components/layout/main')), 'Main')
const Dashboard = r =>
  require.ensure(
    [],
    () => r(require('@/components/layout/dashboard')),
    'Dashboard'
  )
const notFind = r =>
  require.ensure([], () => r(require('@components/common/404')), 'notFind')
import hsEdi from '@app/HsEdi/edi_router'
Vue.use(Router)
export default new Router({
  routes: [
    hsEdi,
    {
      path: '/',
      name: 'main',
      component: Dashboard,
      children: [
        {
          name: '首页',
          path: 'dashboard',
          component: Dashboard,
          meta: {
            tabAttr: 'constant',
            value: 'dashboard',
            requiresAuth: true
          }
        }
      ]
    },
    {
      path: '/error',
      name: 'error',
      component: Main,
      children: [
        {
          path: '*',
          component: notFind,
          meta: {
            title: '404未找到'
          }
        }
      ]
    },
    {
      path: '/login',
      name: 'login',
      component: Login
    },
    {
      path: '/logout',
      name: 'logout'
    },
    {
      path: '/register',
      name: 'register',
      component: Register
    },
    {
      path: '/retrievePassword',
      name: 'retrievePassword',
      component: retrievePassword
    }
  ]
})
