function getRouter(tab) {
  // 目前采用一个表单一个tab并使用keep-alive，所以不需要使用全路由跳转
  // if (Object.keys(tab.query).length > 0) return {path: tab.path, query: tab.query}
  // if (Object.keys(tab.params).length > 0) return {name: tab.routerName, params: tab.params}
  return tab.path
}
const state = {
  token: '',
  activeTabIndex: 0,
  username: '',
  toggleMenu: false,
  permissions: 'editor',
  headerTabs: [
    {
      name: '首页',
      meta: {
        tabAttr: 'constant',
        value: 'dashboard'
      },
      routerName: '首页',
      params: {},
      path: '/dashboard',
      query: {}
    }
  ],
  loading: false,
  keepInclude: [],
  keepExclude: [],
  roCopyInfo: {},
  isNewTab: {
    index: '',
    falge: false
  }
}

const mutations = {
  set_token(state, token) {
    state.mes_token = token
    sessionStorage.mes_token = token
  },
  del_token(state) {
    state.token = ''
    sessionStorage.removeItem('mes_token')
  },
  changeIsNewTab(state, data) {
    state.isNewTab = data
  },
  // 需求订单挂组件复制
  addCopyInfoForRo(state, data) {
    state.roCopyInfo = data
  },
  // 全局增加tab选项卡方法
  pushHeaderTab(state, tab) {
    const result = state.headerTabs.find((item, index) => {
      if (item.meta.value === tab.meta.value) {
        state.headerTabs[index] = tab
        state.activeTabIndex = index
        state.isNewTab.flage = false
        return item
      }
    })
    if (!result) {
      state.headerTabs.push(tab)
      state.isNewTab.index = state.headerTabs.length - 1
      state.isNewTab.flage = true
      this.commit('changeKeepInclude', tab.meta.value)
      state.activeTabIndex = state.headerTabs.length - 1
    }
    // for (let index = 0; index < state.headerTabs.length; index++) {
    //   if (state.headerTabs[index].meta.value === tab.meta.value) {
    //     state.headerTabs[index] = tab
    //     // state.headerTabs[index].link = tab.link
    //     state.activeTabIndex = index
    //     break
    //   } else if (state.headerTabs.length === index + 1 && state.headerTabs[index].meta.value !== tab.meta.value) {
    //     state.headerTabs.push(tab)
    //     this.commit('changeKeepInclude', tab.meta.value)
    //     state.activeTabIndex = state.headerTabs.length - 1
    //     break
    //   }
    // }
  },
  // 点击tab选项卡删除键方法
  deleteHeaderTab(state, data = { that: {}, index: '' }) {
    const that = data.that
    const index = parseInt(data.index)
    const activeTab = state.headerTabs[state.activeTabIndex]
    const nextTab = state.headerTabs[index + 1] || state.headerTabs[index - 1]
    const deleteTab = state.headerTabs[index]
    this.commit('changeKeepExclude', deleteTab.meta.value)
    if (state.isNewTab.index === index) {
      state.isNewTab.flage = false
    }
    state.headerTabs.splice(index, 1)
    if (nextTab) {
      // 为什么要判断一下呢？
      // 如果当前路由（activeTab）就是下个目标路由（nextTab）
      // 直接跳转（that.$router.push(nextTab.link)）vue-router会判断路由一样就不会跳转（就不执行 pushHeaderTab函数）
      if (activeTab.meta.value === nextTab.meta.value) {
        state.headerTabs.forEach((item, key) => {
          if (nextTab.meta.value === item.meta.value) {
            state.activeTabIndex = key
          }
        })
      } else {
        that.$router.push(getRouter(nextTab))
      }
    }
  },
  changeActiveTabIndex(state, data = { that: {}, index: '' }) {
    const that = data.that
    const index = data.index
    if (state.activeTabIndex === parseInt(index)) return false
    const nextTab = state.headerTabs[index]
    if (nextTab) {
      that.$router.push(getRouter(nextTab))
    }
  },
  toggleMenu(state, flag) {
    state.toggleMenu = flag
  },
  loadingChange(state, val) {
    state.loading = val
  },
  changeKeepInclude(state, item) {
    if (state.keepInclude.indexOf(item) === -1) {
      state.keepInclude.push(item)
    }
  },
  changeKeepExclude(state, item) {
    const index = state.keepInclude.indexOf(item)
    if (index === -1) return
    state.keepInclude.splice(index, 1)
  }
}
const getters = {
  activeTabIndex: state => state.activeTabIndex,
  headerTabs: state => state.headerTabs,
  toggleMenu: state => state.toggleMenu,
  keepInclude: state => state.keepInclude,
  keepExclude: state => state.keepExclude,
  copyData: state => state.roCopyInfo,
  getisNewTab: state => state.isNewTab
}
const globalStore = {
  state,
  getters,
  mutations
}
export default globalStore
