const state = {
  error_info: {
    error_title: '',
    error_detail: ''
  },
  error_dialog_visible: false,
  bug_sql_info: [],
  bug_sql_dialog_visible: false
}

const mutations = {
  set_error_info(state, data) {
    state.error_info = data
    state.error_dialog_visible = true
  },
  change_error_dialog_visible(state, status) {
    state.error_dialog_visible = status
  },
  set_dug_sql_error_info(state, data) {
    state.bug_sql_info.unshift(data)
  },
  clean_bug_sql_info(state) {
    state.bug_sql_info = []
  }
}
const getters = {
  get_error_info: state => state.error_info,
  get_error_dialog_visible: state => state.error_dialog_visible,
  get_bug_sql_info: state => state.bug_sql_info
}
const sysStore = {
  state,
  getters,
  mutations
}
export default sysStore
