/**
 * 签名验证
 */
// const sha256 = require('utils/sha256.js');
import sha256 from 'crypto-js/hmac-sha256'
import UTF8 from 'crypto-js/enc-utf8'
const config = {
  makeSignPlain(queryStringMap, body, timestamp, nonce) {
    let signPlain = ''
    ;[...queryStringMap.keys()]
      .sort((a, b) => {
        if (a.toString().toLowerCase() > b.toString().toLowerCase()) {
          return 1
        }
        return -1
      })
      .forEach(key => {
        if (queryStringMap.get(key) !== '') {
          signPlain += `${key}=${queryStringMap.get(key)}&`
        }
      })
    if (signPlain.length > 1) {
      signPlain = signPlain.substring(0, signPlain.length - 1)
    }
    if (body) {
      signPlain += JSON.stringify(body)
    }
    signPlain += timestamp.toString() + nonce.toString()
    console.log('签名结果：', signPlain)
    // signPlain = sha256.hmac('018f162e804f945ee6b23aebfa863639', signPlain);
    signPlain = sha256(signPlain, '018f162e804f945ee6b23aebfa863639').toString(
      UTF8.Utfd
    )
    return signPlain
  },
  getRandom(len = 5) {
    return parseInt(Math.random() * Math.pow(10, len))
  },
  getTimeStamp() {
    return parseInt(new Date().getTime() / 1000)
  },
  IgnoreTransform(a, b) {
    if (a.toString().toLowerCase() > b.toString().toLowerCase()) {
      return 1
    }
    return -1
  }
}

module.exports = config
