package com.hs.admin.base;

public enum CodeMessageEnum {
    REQUEST_SUCCESS("200", "服务成功返回请求数据"),

    UPDATE_SUCCESS("201", "新建或修改数据成功"),

    ASYNC_TASK("202", "异步任务"),

    DELETE_SUCCESS("204", "删除数据成功"),

    REQUEST_ERROR("400", "请求错误"),

    NOT_AUTHORITY("401", "用户没有权限"),

    RELATIONS_EXIST("402", "有用户正在参与活动，无法执行编辑或删除操作"),

    ACCESS_BARRED("403", "禁止访问"),

    RECORDS_NOT_EXIST("404", "记录不存在"),

    QUOTA_OCCUPIED("802", "名额被占用,无法获取"),

    FORMAT_NOT_AVAILABLE("406", "格式不可得"),

    RESOURCES_HAS_DELETE("410", "资源已被删除"),

    VALIDATION_ERROR("422", "创建对象时验证错误"),

    SERVICE_ERROR("500", "服务器错误"),

    GATEWAY_ERROR("502", "网关错误"),

    SERVICE_NOT_AVAILABLE("503", "服务不可用"),

    GATEWAY_TIMEOUT("504", "网关超时");
    private String code;

    private String msg;

    CodeMessageEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getcode(String msg) {
        for (CodeMessageEnum codeMsg : CodeMessageEnum.values()) {
            if (codeMsg.msg.equals(msg)) {
                return codeMsg.code;
            }
        }
        return null;
    }

    /**
     * @description: 获取错误信息
     * @param: code
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/6 10:08 上午
     */
    public String getMsg(String code) {
        for (CodeMessageEnum codeMsg : CodeMessageEnum.values()) {
            if (codeMsg.code.equals(code)) {
                return codeMsg.msg;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}