package com.hs.admin.controller;

import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.base.PageResult;
import com.hs.admin.base.Result;
import com.hs.admin.dto.TaskDto;
import com.hs.admin.service.TaskService;
import com.hs.admin.util.JsonUtils;
import com.hs.admin.util.LoginUserUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author xieheng
 */
@RestController
public class TaskController {
    @Resource
    LoginUserUtil loginUserUtil;
    @Resource
    TaskService taskService;

    /**
     * @description: 添加任务
     * @param: dto
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/10 3:23 下午
     */
/*
    @PutMapping(value = "/api/admin/saveTask")
    public String saveTask(@RequestBody @Validated TaskDto dto) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            boolean b = taskService.saveTask(dto);
            if (b) {
                result = Result.returnSuccess(null);
            } else {
                result = Result.returnError();
            }
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            result = Result.returnError();
        }
        return JsonUtil.beanToJson(result);
    }

    @GetMapping(value = "/api/admin/delTask")
    public String delTask(Integer taskId) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            boolean b = taskService.delTask(taskId);
            if (b) {
                result = Result.returnSuccess(null);
            } else {
                result = Result.returnError();
            }
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            result = Result.returnError();
        }
        return JsonUtil.beanToJson(result);
    }
  */

    /**
     * @description: 获取分页数据
     * @param: taskDto
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/10 3:38 下午
     */
    @GetMapping(value = "/api/admin/getTaskList")
    public String getTaskList(TaskDto taskDto) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            PageResult<Map> pageResult = taskService.getTaskList(taskDto);
            result = Result.returnSuccess(pageResult);
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }
}
