package com.hs.admin.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.hs.admin.base.CodeMessageEnum;
import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.base.PageResult;
import com.hs.admin.base.StateEnum;
import com.hs.admin.bean.Jcb;
import com.hs.admin.dao.JcbDao;
import com.hs.admin.dao.SysTaskDao;
import com.hs.admin.dto.JcbDto;
import com.hs.admin.service.JcbService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author xieheng
 */
@Service
public class JcbServiceImpl implements JcbService {
    @Resource
    JcbDao jcbDao;
    @Resource
    SysTaskDao sysTaskDao;

    @Override
    public boolean saveJcb(JcbDto jcbDto) {
        Integer id = jcbDto.getId();
        Integer jcbId = jcbDto.getJcbId();
        String jcbName = jcbDto.getJcbName();
        String remark = jcbDto.getRemark();
        String dbName = jcbDto.getDbName();
        String host = jcbDto.getHost();
        String port = jcbDto.getPort();
        String username = jcbDto.getDbUsername();
        String pwd = jcbDto.getDbPwd();
        Integer type = jcbDto.getType();
        Jcb jcb = new Jcb();
        jcb.setJcbId(jcbId);
        jcb.setName(jcbName);
        jcb.setRemark(StringUtils.isEmpty(remark) ? "" : remark);
        jcb.setHost(host);
        jcb.setPort(port);
        jcb.setDbName(dbName);
        jcb.setDbUsername(username);
        jcb.setDbPwd(pwd);
        jcb.setType(ObjectUtils.isEmpty(type) ? 1 : type);
        if (id == null) {
            jcb.setState(StateEnum.ENABLE.getCode());
            jcb.setGmtCreate(new Date());
            return jcbDao.insert(jcb) == 1;
        } else {
            jcb.setId(id);
            return jcbDao.updateById(jcb) == 1;
        }
    }

    /**
     * @description: 删除租户
     * @param: jcbId
     * @return: boolean
     * @author: XieHeng
     * @date: 2021/5/10 9:01 上午
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean delJcb(Integer id) {
        if (id == null || id < 1) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "参数错误");
        }
        //校验是否有存在正常的任务。否则不能删除租户
        int i = jcbDao.checkTask(id);
        if (i > 0) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "租户存在任务，不能删除");
        }
        if (jcbDao.delJcb(id) == 1) {
            sysTaskDao.delTaskById(id);
            return true;
        }
        throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "删除失败");
    }

    @Override
    public PageResult<Jcb> getJcbList(Integer pageNum, Integer pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        List<Jcb> jcbList = jcbDao.findAllByState();
        PageInfo<Jcb> info = new PageInfo<>(jcbList);
        return new PageResult<>(info.getTotal(), info.getList());
    }

}
