package com.hs.admin.controller;

import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.base.PageResult;
import com.hs.admin.base.Result;
import com.hs.admin.bean.Jcb;
import com.hs.admin.dto.JcbDto;
import com.hs.admin.service.JcbService;
import com.hs.admin.util.JsonUtils;
import com.hs.admin.util.LoginUserUtil;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author xieheng
 */
@RestController
public class JcbController {
    @Resource
    LoginUserUtil loginUserUtil;
    @Resource
    JcbService jcbService;

    /**
     * @description: 添加租户/修改
     * @param: jcbDto
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/10 8:49 上午
     */
    @PutMapping(value = "/api/admin/saveJcb")
    public String saveJcb(@RequestBody @Validated JcbDto jcbDto) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            boolean b = jcbService.saveJcb(jcbDto);
            if (b) {
                result = Result.returnSuccess(null);
            } else {
                result = Result.returnError();
            }
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }

    /**
     * @description: 删除租户
     * @param: jcbId
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/10 9:02 上午
     */
    @GetMapping(value = "/api/admin/deleteJcb")
    public String delJcb(Integer id) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            boolean b = jcbService.delJcb(id);
            if (b) {
                result = Result.returnSuccess(null);
            } else {
                result = Result.returnError();
            }
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }

    /**
     * @description: 获取租户列表
     * @param: pageNum
     * @param: pageSize
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/10 9:04 上午
     */
    @GetMapping(value = "/api/admin/getJcbList")
    public String getJcbList(@RequestParam(defaultValue = "1") Integer pageNum, @RequestParam(defaultValue = "20") Integer pageSize) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            PageResult<Jcb> pageResult = jcbService.getJcbList(pageNum, pageSize);
            result = Result.returnSuccess(pageResult);
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }
}
