package com.hs.admin.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.hs.admin.base.CodeMessageEnum;
import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.base.PageResult;
import com.hs.admin.base.StateEnum;
import com.hs.admin.bean.Jcb;
import com.hs.admin.bean.SysTask;
import com.hs.admin.dao.SysTaskDao;
import com.hs.admin.dto.TaskDto;
import com.hs.admin.service.JcbService;
import com.hs.admin.service.TaskService;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import javax.print.attribute.standard.JobName;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xieheng
 */
@Service
public class TaskServiceImpl implements TaskService {
    @Resource
    SysTaskDao taskDao;
    @Resource
    JcbService jcbService;

    @Override
    public boolean saveTask(TaskDto dto) {
        Integer jcbId = dto.getJcbId();
        Integer id = dto.getId();
        String beanClass = dto.getBeanClass();
        String cronExpression = dto.getCronExpression();
        String jobGroup = dto.getJobGroup();
        Integer type = dto.getType();
        String name = dto.getName();
        SysTask sysTask = new SysTask();
        if (!StringUtils.isEmpty(name)) {
            sysTask.setJobName(name);
        }
        if (!StringUtils.isEmpty(type)) {
            sysTask.setType(type);
        }
        if (!StringUtils.isEmpty(cronExpression)) {
            sysTask.setCronExpression(cronExpression);
        }
        if (!StringUtils.isEmpty(beanClass)) {
            sysTask.setBeanClass(beanClass);
        }
        if (!StringUtils.isEmpty(name)) {
            sysTask.setJobName(name);
        }
        if (!StringUtils.isEmpty(jobGroup)) {
            sysTask.setJobGroup(jobGroup);
        }
        if (id == null) {
            sysTask.setJcbId(jcbId);
            sysTask.setContent("");
            sysTask.setJobStatus(StateEnum.ENABLE.getCode());
            sysTask.setCreateTime(new Date());
            sysTask.setUpdateTime(new Date());
            return taskDao.insert(sysTask) == 1;
        } else {
            sysTask.setId(id);
            return taskDao.updateByPrimaryKey(sysTask) == 1;
        }
    }

    @Override
    public boolean delTask(Integer taskId) {
        int i = 0;
        try {
            i = taskDao.delTask(taskId);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return i == 1;
    }

    @Override
    public PageResult<Map> getTaskList(TaskDto taskDto) {
        Integer jcbId = taskDto.getJcbId();
        if (jcbId == null) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "缺少租户Id");
        }
        HashMap<String, Object> map = new HashMap<>();
        map.put("jcbId", jcbId);
        PageHelper.startPage(taskDto.getPageNum(), taskDto.getPageSize());
        List<Map> sysTaskList = taskDao.findAllByCondition(map);
        PageInfo<Map> info = new PageInfo<>(sysTaskList);
        return new PageResult<>(info.getTotal(), info.getList());
    }
}
