package com.hs.admin.factory;

import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.stereotype.Component;

/**
 * @author xieheng
 */
@Component
public class JobFactory extends AdaptableJobFactory {
    @Autowired
    AutowireCapableBeanFactory autowireCapableBeanFactory;

    @Override
    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {

        Object jobInstance = super.createJobInstance(bundle);
        //将任务自动注入到factory
        autowireCapableBeanFactory.autowireBean(jobInstance);
        return jobInstance;
    }
}
