package com.hs.admin.listener;


import com.hs.admin.base.RabbitMqConstant;
import com.hs.admin.bean.OperateEnum;
import com.hs.admin.bean.SysTask;
import com.hs.admin.dao.JcbDao;
import com.hs.admin.service.SchedulerJobService;
import com.hs.admin.util.JsonUtils;
import com.hs.admin.util.LogUtil;
import com.rabbitmq.client.Channel;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author xieheng
 */
@Component
public class RabbitMqListener {
    @Resource
    RabbitTemplate rabbitTemplate;
    @Resource
    MyMessageListener messageListener;
    @Resource
    SchedulerJobService schedulerJobService;
    @Resource
    JcbDao jcbDao;

    @Bean
    public SimpleMessageListenerContainer messageListenerContainer(ConnectionFactory connectionFactory) {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setQueueNames(getAllQueueName());
        LogUtil.info(">>>>>>>监听队列"+JsonUtils.beanToJson(container.getQueueNames()));
        container.setMessageListener(messageListener);
        return container;
    }

    public String[] getAllQueueName() {
        List<String> jcbIdList = jcbDao.getJcbIdList();
        List<String> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(jcbIdList)) {
            for (String jcbId : jcbIdList) {
                String queueName = RabbitMqConstant.JOB_QUEUE + jcbId;
                list.add(queueName);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    /**
     * @description:新增队列
     * @author: XieHeng
     * @param: queueName
     * @return: void
     * @date: 2021/5/25 1:49 下午
     */
    public void newQueue(String queueName) {
        ConnectionFactory connectionFactory = rabbitTemplate.getConnectionFactory();
        Connection connection = connectionFactory.createConnection();
        Channel channel = connection.createChannel(true);
        try {
            channel.queueDeclare(queueName, false, false, false, null);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                channel.close();
                connection.close();
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

}
