package com.hs.admin.scheduler;

import com.hs.admin.base.CodeMessageEnum;
import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.bean.AuthToken;
import com.hs.admin.bean.Jcb;
import com.hs.admin.dao.AuthTokenDao;
import com.hs.admin.dao.JcbDao;
import com.hs.admin.util.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author xieheng
 */
@Component
public class TokenUtil {

    @Value("${ocid_client_id}")
    private String clientId;
    @Value("${ocid_client_secret}")
    private String clientSecret;
    @Value("${ocid_scope}")
    private String scope;
    @Value("${ocid_password}")
    private String password;
    @Value("${ocid_token_url}")
    private String interfaceTokenUrl;
    @Resource
    AuthTokenDao authTokenDao;

    public String getToken(String jcbId) {
        String accessToken = null;
        HashMap<String, Object> map = new HashMap<>();
        map.put("grant_type", "password");
        map.put("client_id", clientId);
        map.put("client_secret", clientSecret);
        HashMap<Object, Object> userMap = new HashMap<>();
        userMap.put("TenantCode", jcbId);
        userMap.put("UserNo", "admin");
        userMap.put("Lang", "cn");
        map.put("username", JsonUtils.beanToJson(userMap));
        map.put("password", password);
        map.put("scope", scope);
        String result = HttpUtil.post(interfaceTokenUrl, map);
        LogUtil.info(">>>>>获取token");
        if (!ObjectUtils.isEmpty(result)) {
            Map<String, Object> objectMap = JsonUtils.jsonToMap(result);
            if (objectMap != null) {
                accessToken = objectMap.get("access_token").toString();

                return accessToken;
            }
        }
        throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(),"获取token失败");
    }

}
