package com.hs.admin.service.impl;

import com.hs.admin.base.CodeMessageEnum;
import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.base.PageResult;
import com.hs.admin.base.StateEnum;
import com.hs.admin.bean.DataBase;
import com.hs.admin.bean.Jcb;
import com.hs.admin.dao.JcbDao;
import com.hs.admin.dao.SysTaskDao;
import com.hs.admin.dto.JcbDto;
import com.hs.admin.service.JcbService;
import com.hs.admin.util.DynamicDataBaseUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author xieheng
 */
@Service
public class JcbServiceImpl implements JcbService {
    @Resource
    JcbDao jcbDao;
    @Resource
    SysTaskDao sysTaskDao;

    @Override
    public Jcb saveJcb(JcbDto jcbDto) {
        Integer id = jcbDto.getId();
        String jcbId = jcbDto.getJcbId();
        String jcbName = jcbDto.getJcbName();
        String remark = jcbDto.getRemark();
        String dbName = jcbDto.getDbName();
        String host = jcbDto.getHost();
        String port = jcbDto.getPort();
        String username = jcbDto.getDbUsername();
        String pwd = jcbDto.getDbPwd();
        Integer type = ObjectUtils.isEmpty(jcbDto.getType()) ? 1 : jcbDto.getType();
        if (StringUtils.isEmpty(jcbId)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "租户编号不能为空");
        }
        if (StringUtils.isEmpty(jcbName)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "租户名称不能为空");
        }
        if (StringUtils.isEmpty(dbName)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "数据库表名称不能为空");
        }
        if (StringUtils.isEmpty(host)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "数据库连接不能为空");
        }
        if (StringUtils.isEmpty(port)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "数据库端口号不能为空");
        }
        if (StringUtils.isEmpty(username)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "数据库账号不能为空");
        }
        if (StringUtils.isEmpty(pwd)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "数据库密码不能为空");
        }
        DataBase dataBase = new DataBase();
        dataBase.setHost(host);
        dataBase.setPort(port);
        dataBase.setName(dbName);
        dataBase.setUsername(username);
        dataBase.setPassword(pwd);
        dataBase.setDbType(String.valueOf(type));
        checkDb(dataBase);
        Jcb jcb = new Jcb();
        jcb.setJcbId(jcbId);
        jcb.setName(jcbName);
        jcb.setRemark(StringUtils.isEmpty(remark) ? "" : remark);
        jcb.setHost(host);
        jcb.setPort(port);
        jcb.setDbName(dbName);
        jcb.setDbUsername(username);
        jcb.setDbPwd(pwd);
        jcb.setDbType(ObjectUtils.isEmpty(type) ? 1 : type);
        if (id == null) {
            Jcb dbjcb = jcbDao.getCount(jcbId);
            if (dbjcb != null) {
                if (dbjcb.getState() != 3) {
                    throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "租户已经存在，不能重复添加");
                } else {
                    jcb.setGmtCreate(new Date());
                    jcb.setGmtModify(new Date());
                    jcb.setState(StateEnum.ENABLE.getCode());
                    jcb.setId(dbjcb.getId());
                    jcbDao.updateById(jcb);
                }
            } else {
                jcb.setState(StateEnum.ENABLE.getCode());
                jcb.setGmtCreate(new Date());
                jcb.setGmtModify(new Date());
                jcbDao.insert(jcb);
            }
        } else {
            jcb.setId(id);
            jcbDao.updateById(jcb);
        }
        return jcb;
    }

    /**
     * @description: 删除租户
     * @param: jcbId
     * @return: boolean
     * @author: XieHeng
     * @date: 2021/5/10 9:01 上午
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delJcb(String id) {
        if (ObjectUtils.isEmpty(id)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "参数错误");
        }
        //校验是否有存在正常的任务。否则不能删除租户
        int i = jcbDao.delJcb(id);
        if (i != 1) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "删除失败");
        }
        sysTaskDao.deleteByJcbId(id);
    }

    @Override
    public PageResult<Jcb> getJcbList(Integer pageNum, Integer pageSize) {
        Integer index = (pageNum - 1) * pageSize;
        Long totalCount = jcbDao.getTotalCount();
        List<Jcb> jcbList = jcbDao.findPage(index, pageSize);
        return new PageResult<>(totalCount, jcbList);
    }

    @Override
    public void checkDb(DataBase dataBase) {
        boolean b = DynamicDataBaseUtil.checkDataBaseConnection(dataBase);
        if (!b) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "数据库校验失败");
        }
    }

}
