package com.hs.admin.service.impl;

import com.hs.admin.base.CodeMessageEnum;
import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.bean.SysTask;
import com.hs.admin.dao.SysTaskDao;
import com.hs.admin.service.JobManagerService;
import com.hs.admin.service.SchedulerJobService;
import com.hs.admin.util.JsonUtils;
import com.hs.admin.util.LogUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;

/**
 * @author xieheng
 */
@Service
public class SchedulerJobServiceImpl implements SchedulerJobService {
    @Resource
    JobManagerService jobManagerService;

    /**
     * @description: 校验任务id
     * @param: taskId
     * @param: request
     * @return: void
     * @author: XieHeng
     * @date: 2021/5/6 11:03 上午
     */
    private void checkId(Long taskId, String prefix) {
        if (taskId < 1) {
            LogUtil.error(prefix + "参数错误：taskId=" + taskId);
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), CodeMessageEnum.REQUEST_ERROR.getMsg());
        }
    }


    @Override
    public boolean initJob(SysTask task) {
        return excuteInitJobOperate(task);
    }

    /**
     * @description: 立即执行，只运行一次
     * @param: sysTask
     * @return: boolean
     * @author: XieHeng
     * @date: 2021/5/7 2:56 下午
     */
    @Override
    public boolean runNow(SysTask sysTask) {
        return jobManagerService.runJobNow(sysTask);
    }

    private boolean excuteInitJobOperate(SysTask task) {
        if (!ObjectUtils.isEmpty(task)) {
            return jobManagerService.addJob(task);
        } else {
            LogUtil.error("初始化定时任务失败");
            throw new HsRuntimeException(CodeMessageEnum.RECORDS_NOT_EXIST.getCode(), CodeMessageEnum.RECORDS_NOT_EXIST.getMsg());
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean pauseJob(SysTask task) {
        if (!ObjectUtils.isEmpty(task)) {
            return jobManagerService.pauseJob(task);
        } else {
            LogUtil.error("暂停任务失败:" + JsonUtils.beanToJson(task));
            throw new HsRuntimeException(CodeMessageEnum.RECORDS_NOT_EXIST.getCode(), CodeMessageEnum.RECORDS_NOT_EXIST.getMsg());
        }
    }

    @Override
    public boolean resumeJob(SysTask task) {
        if (!ObjectUtils.isEmpty(task)) {
            boolean b = jobManagerService.resumeJob(task);
            if (b) {
                LogUtil.error("恢复任务" + JsonUtils.beanToJson(task));
                return b;
            }
        }
        LogUtil.error("恢复任务失败" + JsonUtils.beanToJson(task));
        throw new HsRuntimeException(CodeMessageEnum.RECORDS_NOT_EXIST.getCode(), CodeMessageEnum.RECORDS_NOT_EXIST.getMsg());

    }

    @Override
    public boolean deleteJob(SysTask task) {
        if (!ObjectUtils.isEmpty(task)) {
            return jobManagerService.deleteJob(task);
        } else {
            LogUtil.error("删除任务失败" + JsonUtils.beanToJson(task));
            throw new HsRuntimeException(CodeMessageEnum.RECORDS_NOT_EXIST.getCode(), CodeMessageEnum.RECORDS_NOT_EXIST.getMsg());
        }
    }

    @Override
    public SysTask editCron(SysTask task, String cron) {
        if (ObjectUtils.isEmpty(task)) {
            throw new HsRuntimeException(CodeMessageEnum.RECORDS_NOT_EXIST.getMsg(), CodeMessageEnum.RECORDS_NOT_EXIST.getMsg());
        }
        task.setCronExpression(cron);
        jobManagerService.updateJobCron(task);
        jobManagerService.runJobNow(task);
        return task;
    }




}
