package com.hs.admin.util;

import com.hs.admin.bean.DataBase;
import com.hs.admin.bean.Jcb;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DbUtil {

    /**
     * @description: 读取本地配置文件
     * @param: jcbId
     * @return: DataBase
     * @author: XieHeng
     * @date: 2021/5/7 4:11 下午
     */
    public static DataBase readProperties(String jcbId) {
        InputStream inputStream = DbUtil.class.getClassLoader().getResourceAsStream("dbconfig/db.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            String host = properties.getProperty(jcbId + "_db_host");
            String port = properties.getProperty(jcbId + "_db_port");
            String username = properties.getProperty(jcbId + "_db_username");
            String password = properties.getProperty(jcbId + "_db_password");
            String dbName = properties.getProperty(jcbId + "_db_name");
            String type = properties.getProperty(jcbId + "_db_type");
            String driver = "";
            String url = "";
            switch (type) {
                //1sqlserver,2mysql,3oracle
                case "1":
                    driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                    url = "jdbc:sqlserver://" + host + ":" + port + ";DatabaseName=" + dbName;
                    break;
                case "2":
                    driver = "com.mysql.cj.jdbc.Driver";
                    url = "jdbc:mysql://" + host + ":" + port + "/" + dbName;
                    break;
                case "3":
                    driver = "oracle.jdbc.OracleDriver";
                    url = "jdbc:oracle:thin:@//" + host + ":" + port + "/" + dbName;
                    break;
                default:
                    break;
            }
            return new DataBase(host, port, dbName, username, password, type, driver, url);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * @description:获取sqlserver JdbcTemplate
     * @author: XieHeng
     * @param: dbInfo
     * @return: NamedParameterJdbcTemplate
     * @date: 2021/5/24 5:14 下午
     */
    public static JdbcTemplate getJdbcTemplate(DataBase dbInfo) {
        SQLServerDataSource ds = new SQLServerDataSource();
        DataBase dataBase = getDataBaseInfo(dbInfo);
        ds.setUser(dataBase.getUsername());
        ds.setPassword(dataBase.getPassword());
        ds.setServerName(dataBase.getHost());
        ds.setPortNumber(Integer.parseInt(dataBase.getPort()));
        ds.setDatabaseName(dataBase.getName());
        ds.setLoginTimeout(10);
        return new JdbcTemplate(ds);
    }

    public static DataBase getDataBase(Jcb jcb) {
        DataBase dataBase = new DataBase();
        dataBase.setHost(jcb.getHost());
        dataBase.setPort(jcb.getPort());
        dataBase.setName(jcb.getDbName());
        dataBase.setUsername(jcb.getDbUsername());
        dataBase.setPassword(jcb.getDbPwd());
        dataBase.setDbType(String.valueOf(jcb.getDbType()));
        return dataBase;
    }

    /**
     * @description:获取数据库信息
     * @author: XieHeng
     * @param: dataBase
     * @return: DataBase
     * @date: 2021/5/24 5:14 下午
     */
    public static DataBase getDataBaseInfo(DataBase dataBase) {
        String host = dataBase.getHost();
        String dbName = dataBase.getName();
        String port = dataBase.getPort();
        String driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        String url = "jdbc:sqlserver://" + host + ":" + port + ";DatabaseName=" + dbName;
        dataBase.setDbDriver(driver);
        dataBase.setUrl(url);
        return dataBase;
    }
}
