package com.hs.admin.base;


import lombok.AllArgsConstructor;

import java.io.Serializable;


/**
 * @author xieheng
 */
public class Result implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 状态码
     */
    private Boolean success;

    /**
     * 结果消息
     */
    private String message;

    /**
     * 错误码
     */
    private String code;

    /**
     * 返回的数据
     */
    private Object data;

    /**
     * 当前系统时间
     */
    private Long timeStamp;

    public Result() {
    }

    /**
     * 构造函数
     *
     * @param success
     * @param message
     * @param code
     * @param data
     */
    public Result(Boolean success, String message, String code, Object data) {
        this.success = success;
        this.message = message;
        this.code = code;
        this.data = data;
        this.timeStamp = System.currentTimeMillis();
    }

    /**
     * 构造函数
     *
     * @param success
     * @param code
     * @param data
     */
    public Result(Boolean success, String code, Object data) {
        this.success = success;
        this.code = code;
        this.data = data;
        this.timeStamp = System.currentTimeMillis();
    }

    public Result(Boolean success, String message, String code, Object data, long timeStamp) {
        this.success = success;
        this.message = message;
        this.code = code;
        this.data = data;
        this.timeStamp = timeStamp;
    }

    /**
     * 返回失败
     *
     * @param codeMessageEnum
     * @return
     */
    public static Result returnError(CodeMessageEnum codeMessageEnum) {
        return new Result(Boolean.FALSE, codeMessageEnum.getMsg(), codeMessageEnum.getCode(), null, System.currentTimeMillis());
    }

    public static Result returnError() {
        return new Result(Boolean.FALSE, CodeMessageEnum.SERVICE_ERROR.getMsg(), CodeMessageEnum.SERVICE_ERROR.getCode(), null, System.currentTimeMillis());
    }

    public static Result returnError(Object data) {
        return new Result(Boolean.FALSE, CodeMessageEnum.SERVICE_ERROR.getMsg(), CodeMessageEnum.SERVICE_ERROR.getCode(), data, System.currentTimeMillis());
    }

    /**
     * 返回成功
     *
     * @param data
     * @return
     */
    public static Result returnSuccess(Object data) {
        return new Result(Boolean.TRUE, CodeMessageEnum.REQUEST_SUCCESS.getMsg(), CodeMessageEnum.REQUEST_SUCCESS.getCode(), data, System.currentTimeMillis());
    }

    public static Result returnSuccess() {
        return new Result(Boolean.TRUE, CodeMessageEnum.REQUEST_SUCCESS.getMsg(), CodeMessageEnum.REQUEST_SUCCESS.getCode(), null, System.currentTimeMillis());
    }

    /**
     * 返回自定义异常
     *
     * @param e
     * @return
     */
    public static Result returnHsException(HsRuntimeException e) {
        return new Result(Boolean.FALSE, e.getMessage(), e.getErrorCode(), null, System.currentTimeMillis());
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }
}