package com.hs.admin.controller;

import com.hs.admin.base.Result;
import com.hs.admin.util.JsonUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.ArrayList;

/**
 * @author xieheng
 */
@Controller
public class LogController {

    @GetMapping(value = "/api/admin/logs")
    public String getLogs(ModelMap modelMap) {
        String path = System.getProperty("user.dir");
        File f = new File(path + "/mylogs");
        System.out.println(f.getPath());
        File[] files = f.listFiles();
        ArrayList<Object> list = new ArrayList<>();
        for (File file : files) {
            list.add(file.getAbsolutePath());
        }
        modelMap.put("list", list);
        return "log";
    }

    @ResponseBody
    @GetMapping(value = "/api/admin/download")
    public void download(String path, HttpServletRequest request, HttpServletResponse response) {
        File f = new File(path);
        try {
            downFile(request, response, "日志", f);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    // 注：
// 获取项目下文件或者文件流

// File file = new File(this.getClass().getResource("/xls/adminImportUserTemplate.xls").toURI());

// in = new BufferedInputStream(this.getClass().getResourceAsStream("/xls/adminImportUserTemplate.xls"));

    /**
     * 下载文件到浏览器
     *
     * @param request
     * @param response
     * @param filename 要下载的文件名
     * @param file     需要下载的文件对象
     * @throws IOException
     */
    public static void downFile(HttpServletRequest request, HttpServletResponse response, String filename, File file) throws IOException {
        //  文件存在才下载
        if (file.exists()) {
            OutputStream out = null;
            FileInputStream in = null;
            try {
                // 1.读取要下载的内容
                in = new FileInputStream(file);

                // 2. 告诉浏览器下载的方式以及一些设置
                // 解决文件名乱码问题，获取浏览器类型，转换对应文件名编码格式，IE要求文件名必须是utf-8, firefo要求是iso-8859-1编码
                String agent = request.getHeader("user-agent");
                if (agent.contains("FireFox")) {
                    filename = new String(filename.getBytes("UTF-8"), "iso-8859-1");
                } else {
                    filename = URLEncoder.encode(filename, "UTF-8");
                }
                // 设置下载文件的mineType，告诉浏览器下载文件类型
                String mineType = request.getServletContext().getMimeType(filename);
                response.setContentType(mineType);
                // 设置一个响应头，无论是否被浏览器解析，都下载
                response.setHeader("Content-disposition", "attachment; filename=" + filename);
                // 将要下载的文件内容通过输出流写到浏览器
                out = response.getOutputStream();
                int len = 0;
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
    }
}
