package com.hs.admin.controller;

import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.base.Result;
import com.hs.admin.dto.UserDto;
import com.hs.admin.service.UserService;
import com.hs.admin.util.JsonUtils;
import com.hs.admin.util.LogUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author xieheng
 */
@Controller
public class LoginController {
    @Resource
    UserService userService;
//    @Resource
//    LoginUserUtil loginUserUtil;

    /**
     * @description: 登录
     * @param: userDto
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/8 3:20 下午
     */
    @ResponseBody
    @PostMapping(value = "/api/admin/login")
    public String login(@RequestBody UserDto userDto) {
        Result result;
        try {
            Map<String, Object> resultMap = userService.login(userDto);
            result = Result.returnSuccess(resultMap);
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            e.printStackTrace();
            LogUtil.error(">>>>>\nlogin错误日志：" + e);
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }

    /**
     * @description: 用户列表
     * @param: pageNum
     * @param: pageSize
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/8 5:37 下午
     */
/*    @GetMapping(value = "/api/admin/userList")
    public String userList(@RequestParam(defaultValue = "1") Integer pageNum, @RequestParam(defaultValue = "20") Integer pageSize) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            List<Map> userList = userService.getList(pageNum, pageSize);
            result = Result.returnSuccess(userList);
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            e.printStackTrace();
            result = Result.returnError();
        }
        return JsonUtil.beanToJson(result);
    }*/
    @GetMapping(value = "/api/admin/index")
    public String index(){
        return "index";
    }
}
