package com.hs.admin.controller;

import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.base.PageResult;
import com.hs.admin.base.Result;
import com.hs.admin.bean.SysTask;
import com.hs.admin.dto.TaskDto;
import com.hs.admin.service.TaskService;
import com.hs.admin.util.JsonUtils;
import com.hs.admin.util.LogUtil;
import com.hs.admin.util.LoginUserUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Map;

/**
 * s
 *
 * @author xieheng
 */
@RestController
public class TaskController {
    @Resource
    LoginUserUtil loginUserUtil;
    @Resource
    TaskService taskService;


    /**
     * @description: 获取分页数据
     * @param: taskDto
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/10 3:38 下午
     */
    @GetMapping(value = "/api/admin/getTaskList")
    public String getTaskList(String jcbId, @RequestParam(defaultValue = "1") Integer pageNum, @RequestParam(defaultValue = "20") Integer pageSize) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            PageResult<Map> pageResult = taskService.getTaskRecordList(jcbId, pageNum, pageSize);
            result = Result.returnSuccess(pageResult);
        } catch (HsRuntimeException e) {
            LogUtil.error("\n>>>>/api/admin/getTaskList错误日志:" + e);
            result = Result.returnHsException(e);
        } catch (Exception e) {e.printStackTrace();
            LogUtil.error("\n>>>>/api/admin/getTaskList错误日志:" + e);
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }

    @GetMapping(value = "/api/admin/getTaskListByCid")
    public String getTaskListByCid(Integer cid,String jcbId, @RequestParam(defaultValue = "1") Integer pageNum, @RequestParam(defaultValue = "20") Integer pageSize) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            PageResult<Map> pageResult = taskService.getTaskListByCid(cid,jcbId, pageNum, pageSize);
            result = Result.returnSuccess(pageResult);
        } catch (HsRuntimeException e) {
            LogUtil.error("\n>>>>/api/admin/getTaskList错误日志:" + e);
            result = Result.returnHsException(e);
        } catch (Exception e) {
            e.printStackTrace();
            LogUtil.error("\n>>>>/api/admin/getTaskList错误日志:" + e);
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }
    @GetMapping(value = "/api/admin/getContentById/{id}")
    public String getContentById(@PathVariable Integer id){
        Result result;
        try {
            loginUserUtil.getLoginUser();
            String content = taskService.getContentById(id);
            result = Result.returnSuccess(content);
        } catch (HsRuntimeException e) {
            LogUtil.error("\n>>>>/api/admin/getTaskList错误日志:" + e);
            result = Result.returnHsException(e);
        } catch (Exception e) {
            LogUtil.error("\n>>>>/api/admin/getTaskList错误日志:" + e);
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }
}
