package com.hs.admin.controller;

import com.hs.admin.dto.UserDto;
import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.base.Result;
import com.hs.admin.service.UserService;
import com.hs.admin.util.JsonUtils;
import com.hs.admin.util.LoginUserUtil;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author xieheng
 */

@RestController
public class UserContrller {
    @Resource
    UserService userService;
    @Resource
    LoginUserUtil loginUserUtil;
/*
    @PutMapping(value = "/api/admin/saveUser")
    public String saveUser(@RequestBody UserDto userDto) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            boolean b = userService.saveUser(userDto);
            if (b) {
                result = Result.returnSuccess(null);
            } else {
                result = Result.returnError();
            }
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            result = Result.returnError();
        }
        return JsonUtil.beanToJson(result);
    }
 */

    /**
     * @description: 修改密码
     * @param: userDto
     * @return: String
     * @author: XieHeng
     * @date: 2021/5/8 3:00 下午
     */
    @PutMapping(value = "/api/admin/editPassword")
    public String editPassword(@RequestBody UserDto userDto) {
        Result result;
        try {
            loginUserUtil.getLoginUser();
            boolean b = userService.editPassword(userDto);
            if (b) {
                result = Result.returnSuccess(null);
            } else {
                result = Result.returnError();
            }
        } catch (HsRuntimeException e) {
            result = Result.returnHsException(e);
        } catch (Exception e) {
            result = Result.returnError();
        }
        return JsonUtils.beanToJson(result);
    }
}
