package com.hs.admin.scheduler;

import com.hs.admin.base.RabbitMqConstant;
import com.hs.admin.bean.Jcb;
import com.hs.admin.dao.JcbDao;
import com.hs.admin.util.LogUtil;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.sqlite.date.DateFormatUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author xieheng
 */
@Component
public class ActiveJcbScheduler {
    @Resource
    RabbitTemplate rabbitTemplate;
    @Resource
    JcbDao jcbDao;

    @Scheduled(cron = "0 0/5 * * * ? ")
    public void checkActiveJcb() {
        LogUtil.info(">>>>>>>>>>>>>客户端发送心跳开始");
        long now = System.currentTimeMillis();
        long ten = 10 * 60 * 1000;
        long before = now - ten;
        List<Jcb> jcbList = jcbDao.findAllByState(before);
        if (!CollectionUtils.isEmpty(jcbList)) {
            for (Jcb jcb : jcbList) {
                LogUtil.info(">>>>>>>>>>>>>客户端发送心跳 id="+jcb.getJcbId());
                rabbitTemplate.convertAndSend(RabbitMqConstant.ACTIVE_QUEUE,jcb.getJcbId());
            }
        }
        LogUtil.info(">>>>>>>>>>>>>客户端发送心跳结束");
    }
}
