package com.hs.admin.util;

import com.hs.admin.base.CodeMessageEnum;
import com.hs.admin.base.HsRuntimeException;
import com.hs.admin.bean.DataBase;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.mysql.cj.jdbc.MysqlDataSource;
import com.zaxxer.hikari.HikariDataSource;
import org.springframework.util.ObjectUtils;

import java.sql.Connection;
import java.sql.SQLException;

public class DynamicDataBaseUtil {
    /**
     * @description: 配置数据库
     * @return: HikariDataSource
     * @author: XieHeng
     * @date: 2021/5/7 5:02 下午
     */
    public static HikariDataSource configure(DataBase dataBase) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(dataBase.getUrl());
        dataSource.setUsername(dataBase.getUsername());
        dataSource.setPassword(dataBase.getPassword());
        dataSource.setDriverClassName(dataBase.getDbDriver());
//        dataSource.setMaximumPoolSize(2);
//        dataSource.setMinimumIdle(1);
        dataSource.setAutoCommit(true);
//        dataSource.setConnectionTestQuery("SELECT 1 FROM DUAL");
        dataSource.addDataSourceProperty("cachePrepStmts", "true");
        dataSource.addDataSourceProperty("prepStmtCacheSize", "250");
        dataSource.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return dataSource;
    }

    public static boolean checkDataBaseConnection(DataBase dataBase) {
        String dbType = dataBase.getDbType();
        String username = dataBase.getUsername();
        String password = dataBase.getPassword();
        String host = dataBase.getHost();
        String port = dataBase.getPort();
        String dbName = dataBase.getName();
        if (ObjectUtils.isEmpty(username) || ObjectUtils.isEmpty(password) || ObjectUtils.isEmpty(host) || ObjectUtils.isEmpty(port) || ObjectUtils.isEmpty(dbType) || ObjectUtils.isEmpty(dbName)) {
            throw new HsRuntimeException(CodeMessageEnum.REQUEST_ERROR.getCode(), "数据库连接失败");
        }
        if ("1".equals(dbType)) {
            SQLServerDataSource ds = new SQLServerDataSource();
            ds.setUser(username);
            ds.setPassword(password);
            ds.setServerName(host);
            ds.setPortNumber(Integer.parseInt(port));
            ds.setDatabaseName(dbName);
            ds.setLoginTimeout(1);
            Connection connection = null;
            try {
                connection = ds.getConnection();
                return true;
            } catch (Exception e) {
                return false;
            } finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                } catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        } else if ("2".equals(dbType)) {
            MysqlDataSource ds = new MysqlDataSource();
            ds.setUser(username);
            ds.setPassword(password);
            ds.setServerName(host);
            ds.setPortNumber(Integer.parseInt(port));
            ds.setDatabaseName(dbName);
            Connection connection = null;
            try {
                connection = ds.getConnection();
                return true;
            } catch (Exception e) {
                return false;
            } finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                } catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        return false;

    }
}
